/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.dim_stack;

import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.peripheral.dim_stack.DimEntryWidget;
import qouteall.imm_ptl.peripheral.dim_stack.DimListWidget;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackEntry;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackEntryEditScreen;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackGuiController;
import qouteall.imm_ptl.peripheral.dim_stack.SelectDimensionScreen;
import qouteall.q_misc_util.my_util.GuiHelper;

@OnlyIn(value=Dist.CLIENT)
public class DimStackScreen
extends Screen {
    private static final Logger LOGGER = LoggerFactory.getLogger(DimStackScreen.class);
    private final DimStackGuiController controller;
    @Nullable
    public final Screen parent;
    private final Button finishButton;
    private final Button toggleButton;
    private final Button addDimensionButton;
    private final Button removeDimensionButton;
    private final Button editButton;
    private final Button helpButton;
    private final Button setAsPresetButton;
    private final Button loopButton;
    private final Button gravityModeButton;
    private int titleY;
    public final DimListWidget dimListWidget;
    private boolean isEnabled = false;

    public DimStackScreen(@Nullable Screen parent, DimStackGuiController controller) {
        super((Component)Component.m_237115_((String)"imm_ptl.altius_screen"));
        this.parent = parent;
        this.toggleButton = Button.m_253074_((Component)Component.m_237113_((String)"..."), buttonWidget -> controller.toggleEnabled()).m_253136_();
        this.loopButton = Button.m_253074_((Component)Component.m_237113_((String)"..."), buttonWidget -> controller.toggleLoop()).m_253136_();
        this.gravityModeButton = Button.m_253074_((Component)Component.m_237113_((String)"..."), gravityModeButton -> controller.toggleGravityMode()).m_253136_();
        this.finishButton = Button.m_253074_((Component)Component.m_237115_((String)"imm_ptl.finish"), buttonWidget -> controller.onFinish()).m_253136_();
        this.controller = controller;
        this.addDimensionButton = Button.m_253074_((Component)Component.m_237115_((String)"imm_ptl.dim_stack_add"), buttonWidget -> this.onAddEntry()).m_253136_();
        this.removeDimensionButton = Button.m_253074_((Component)Component.m_237115_((String)"imm_ptl.dim_stack_remove"), buttonWidget -> this.onRemoveEntry()).m_253136_();
        this.editButton = Button.m_253074_((Component)Component.m_237115_((String)"imm_ptl.dim_stack_edit"), buttonWidget -> this.onEditEntry()).m_253136_();
        this.dimListWidget = new DimListWidget(this.f_96543_, this.f_96544_, 100, 200, 50, this, DimListWidget.Type.mainDimensionList, controller::onDragged);
        this.helpButton = DimStackScreen.createHelpButton(this);
        this.setAsPresetButton = Button.m_253074_((Component)Component.m_237115_((String)"imm_ptl.set_as_dim_stack_default"), button -> this.controller.setAsDefault()).m_253136_();
    }

    public void setLoopEnabled(boolean loopEnabled) {
        this.loopButton.m_93666_((Component)Component.m_237115_((String)(loopEnabled ? "imm_ptl.loop_enabled" : "imm_ptl.loop_disabled")));
    }

    public void setGravityTransformEnabled(boolean gravityTransformEnabled) {
        this.gravityModeButton.m_93666_((Component)Component.m_237115_((String)(gravityTransformEnabled ? "imm_ptl.dim_stack.gravity_transform_enabled" : "imm_ptl.dim_stack.gravity_transform_disabled")));
    }

    public static Button createHelpButton(Screen parent) {
        return Button.m_253074_((Component)Component.m_237113_((String)"?"), button -> CHelper.openLinkConfirmScreen(parent, "https://qouteall.fun/immptl/wiki/Dimension-Stack")).m_253136_();
    }

    public DimEntryWidget createDimEntryWidget(DimStackEntry entry) {
        return new DimEntryWidget(entry.getDimension(), this.dimListWidget, this.getElementSelectCallback(), entry);
    }

    protected void m_7856_() {
        this.m_142416_((GuiEventListener)this.toggleButton);
        this.m_142416_((GuiEventListener)this.finishButton);
        this.m_142416_((GuiEventListener)this.addDimensionButton);
        this.m_142416_((GuiEventListener)this.removeDimensionButton);
        this.m_142416_((GuiEventListener)this.editButton);
        this.m_142416_((GuiEventListener)this.helpButton);
        this.m_142416_((GuiEventListener)this.setAsPresetButton);
        this.m_142416_((GuiEventListener)this.loopButton);
        this.m_142416_((GuiEventListener)this.gravityModeButton);
        this.m_7787_((GuiEventListener)this.dimListWidget);
        GuiHelper.layout(0, this.f_96544_, GuiHelper.blankSpace(5), new GuiHelper.LayoutElement(true, 20, (from, to) -> {
            this.helpButton.m_252865_(this.f_96543_ - 30);
            this.helpButton.m_253211_(from);
            this.helpButton.m_93674_(20);
            this.setAsPresetButton.m_252865_(this.f_96543_ - 125);
            this.setAsPresetButton.m_253211_(from);
            this.setAsPresetButton.m_93674_(90);
        }), new GuiHelper.LayoutElement(true, 20, GuiHelper.combine(GuiHelper.layoutButtonVertically((AbstractWidget)this.toggleButton), GuiHelper.layoutButtonVertically((AbstractWidget)this.loopButton), GuiHelper.layoutButtonVertically((AbstractWidget)this.gravityModeButton))), GuiHelper.blankSpace(5), new GuiHelper.LayoutElement(false, 1, (from, to) -> this.dimListWidget.m_93437_(this.f_96543_, this.f_96544_, from, to)), GuiHelper.blankSpace(5), new GuiHelper.LayoutElement(true, 20, (from, to) -> {
            this.finishButton.m_253211_(from);
            this.addDimensionButton.m_253211_(from);
            this.removeDimensionButton.m_253211_(from);
            this.editButton.m_253211_(from);
            GuiHelper.layout(0, this.f_96543_, GuiHelper.blankSpace(10), new GuiHelper.LayoutElement(false, 1, GuiHelper.layoutButtonHorizontally((AbstractWidget)this.finishButton)), GuiHelper.blankSpace(5), new GuiHelper.LayoutElement(false, 1, GuiHelper.layoutButtonHorizontally((AbstractWidget)this.addDimensionButton)), GuiHelper.blankSpace(5), new GuiHelper.LayoutElement(false, 1, GuiHelper.layoutButtonHorizontally((AbstractWidget)this.removeDimensionButton)), GuiHelper.blankSpace(5), new GuiHelper.LayoutElement(false, 1, GuiHelper.layoutButtonHorizontally((AbstractWidget)this.editButton)), GuiHelper.blankSpace(10));
        }), GuiHelper.blankSpace(5));
        GuiHelper.layout(0, this.f_96543_, GuiHelper.blankSpace(10), new GuiHelper.LayoutElement(false, 10, GuiHelper.layoutButtonHorizontally((AbstractWidget)this.toggleButton)), GuiHelper.blankSpace(5), new GuiHelper.LayoutElement(false, 8, GuiHelper.layoutButtonHorizontally((AbstractWidget)this.loopButton)), GuiHelper.blankSpace(5), new GuiHelper.LayoutElement(false, 10, GuiHelper.layoutButtonHorizontally((AbstractWidget)this.gravityModeButton)), GuiHelper.blankSpace(10));
    }

    public void m_7379_() {
        this.controller.onFinish();
    }

    private Consumer<DimEntryWidget> getElementSelectCallback() {
        return w -> this.dimListWidget.m_6987_((AbstractSelectionList.Entry)w);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        if (this.isEnabled) {
            this.dimListWidget.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        Font font = Minecraft.m_91087_().f_91062_;
        guiGraphics.m_280430_(font, this.f_96539_, 20, 10, -1);
    }

    public void setEnabled(boolean cond) {
        this.isEnabled = cond;
        if (this.isEnabled) {
            this.toggleButton.m_93666_((Component)Component.m_237115_((String)"imm_ptl.altius_toggle_true"));
        } else {
            this.toggleButton.m_93666_((Component)Component.m_237115_((String)"imm_ptl.altius_toggle_false"));
        }
        this.addDimensionButton.f_93624_ = this.isEnabled;
        this.removeDimensionButton.f_93624_ = this.isEnabled;
        this.editButton.f_93624_ = this.isEnabled;
        this.loopButton.f_93624_ = this.isEnabled;
        this.gravityModeButton.f_93624_ = this.isEnabled;
    }

    private void onAddEntry() {
        DimEntryWidget selected = (DimEntryWidget)this.dimListWidget.m_93511_();
        int position = selected == null ? 0 : this.dimListWidget.m_6702_().indexOf((Object)selected);
        if (position < 0 || position > this.dimListWidget.m_6702_().size()) {
            position = -1;
        }
        int insertingPosition = position + 1;
        Minecraft.m_91087_().m_91152_((Screen)new SelectDimensionScreen(this, dimensionType -> this.controller.addEntry(insertingPosition, new DimStackEntry((ResourceKey<Level>)dimensionType)), this.controller.getDimensionList()));
    }

    private void onRemoveEntry() {
        DimEntryWidget selected = (DimEntryWidget)this.dimListWidget.m_93511_();
        if (selected == null) {
            return;
        }
        int position = this.dimListWidget.m_6702_().indexOf((Object)selected);
        if (position == -1) {
            return;
        }
        this.controller.removeEntry(position);
    }

    private void onEditEntry() {
        DimEntryWidget selected = (DimEntryWidget)this.dimListWidget.m_93511_();
        if (selected == null) {
            return;
        }
        Minecraft.m_91087_().m_91152_((Screen)new DimStackEntryEditScreen(this, selected, () -> {
            int newlyChangingEntryIndex = this.dimListWidget.m_6702_().indexOf((Object)selected);
            if (newlyChangingEntryIndex == -1) {
                LOGGER.error("The edited entry is missing in the list");
                return;
            }
            this.controller.editEntry(newlyChangingEntryIndex, selected.entry);
        }));
    }
}

